/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rooms;

import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import technology.rocketjump.undermount.entities.SequentialIdGenerator;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.TileNeighbours;
import technology.rocketjump.undermount.mapping.tile.layout.RoomTileLayout;
import technology.rocketjump.undermount.rooms.RoomTile;
import technology.rocketjump.undermount.rooms.RoomType;
import technology.rocketjump.undermount.rooms.StockpileComponent;

public class Room {
    private final long roomId;
    private final RoomType roomType;
    private final Map<GridPoint2, RoomTile> roomTiles = new HashMap<GridPoint2, RoomTile>();
    private final StockpileComponent stockpileComponent;
    private final Vector2 avgWorldPosition = new Vector2();

    public Room(RoomType roomType) {
        this.roomId = SequentialIdGenerator.nextId();
        this.roomType = roomType;
        this.stockpileComponent = roomType.isStockpileComponent() ? new StockpileComponent(this.roomTiles, this.roomId) : null;
    }

    public long getRoomId() {
        return this.roomId;
    }

    public RoomType getRoomType() {
        return this.roomType;
    }

    public Map<GridPoint2, RoomTile> getRoomTiles() {
        return this.roomTiles;
    }

    public void addTile(RoomTile tile) {
        this.roomTiles.put(tile.getTilePosition(), tile);
        this.recalculatePosition();
    }

    public RoomTile removeTile(GridPoint2 position) {
        this.recalculatePosition();
        return this.roomTiles.remove(position);
    }

    public Set<GridPoint2> keySet() {
        return this.roomTiles.keySet();
    }

    public Set<Map.Entry<GridPoint2, RoomTile>> entrySet() {
        return this.roomTiles.entrySet();
    }

    public Vector2 getAvgWorldPosition() {
        return this.avgWorldPosition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Room room = (Room)o;
        return this.roomId == room.roomId;
    }

    public int hashCode() {
        return Objects.hash(this.roomId);
    }

    public StockpileComponent getStockpileComponent() {
        return this.stockpileComponent;
    }

    public boolean isEmpty() {
        return this.roomTiles.isEmpty();
    }

    public void clearTiles() {
        for (RoomTile roomTile : this.roomTiles.values()) {
            roomTile.getTile().setRoomTile(null);
        }
        this.roomTiles.clear();
    }

    public void updateLayout(TiledMap tiledMap) {
        for (Map.Entry<GridPoint2, RoomTile> entry : this.roomTiles.entrySet()) {
            TileNeighbours neighbours = tiledMap.getNeighbours(entry.getKey().x, entry.getKey().y);
            RoomTileLayout newLayout = new RoomTileLayout(neighbours, this);
            entry.getValue().setLayout(newLayout);
        }
    }

    public void mergeInto(Room targetRoom) {
        for (RoomTile roomTile : this.roomTiles.values()) {
            roomTile.setRoom(targetRoom);
            targetRoom.addTile(roomTile);
        }
    }

    private void recalculatePosition() {
        this.avgWorldPosition.set(0.0f, 0.0f);
        for (GridPoint2 tilePosition : this.roomTiles.keySet()) {
            this.avgWorldPosition.add((float)tilePosition.x + 0.5f, (float)tilePosition.y + 0.5f);
        }
        this.avgWorldPosition.scl(1.0f / (float)this.roomTiles.keySet().size());
    }
}

